<?php
// public/zonas.php
require_once __DIR__ . '/../src/db.php';
$pdo = getPDO();

// Obtener ubicaciones para el select
$ubicaciones = $pdo->query('SELECT * FROM ubicaciones')->fetchAll(PDO::FETCH_ASSOC);

// Crear o editar zona
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'] ?? '';
    $ubicacion_id = $_POST['ubicacion_id'] ?? null;
    $id = $_POST['id'] ?? '';
    if ($nombre && $ubicacion_id) {
        if ($id) {
            $stmt = $pdo->prepare('UPDATE zonas SET nombre = ?, ubicacion_id = ? WHERE id = ?');
            $stmt->execute([$nombre, $ubicacion_id, $id]);
        } else {
            $stmt = $pdo->prepare('INSERT INTO zonas (nombre, ubicacion_id) VALUES (?, ?)');
            $stmt->execute([$nombre, $ubicacion_id]);
        }
    }
    header('Location: zonas.php');
    exit;
}

// Obtener zonas
$zonas = $pdo->query('SELECT z.*, u.nombre as ubicacion FROM zonas z LEFT JOIN ubicaciones u ON z.ubicacion_id = u.id')->fetchAll(PDO::FETCH_ASSOC);
$edit = null;
if (isset($_GET['edit'])) {
    $stmt = $pdo->prepare('SELECT * FROM zonas WHERE id = ?');
    $stmt->execute([$_GET['edit']]);
    $edit = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Zonas</title>
    <link rel="stylesheet" href="style.css">
    <style>
    body { background: #f7fafd; font-family: 'Segoe UI', Arial, sans-serif; }
    nav { width:100%;background:#0078d7;padding:0.7em 0 0.7em 0.5em;margin-bottom:1.5em;box-shadow:0 2px 8px #eee;display:flex;gap:1.5em;align-items:center; }
    nav a { color:#fff;font-weight:500;text-decoration:none;font-size:1.1em; }
    .zonas-container { max-width: 520px; margin: 2em auto; background: #fff; border-radius: 10px; box-shadow: 0 2px 12px #e0e6ed; padding: 2em 2em 1.5em 2em; }
    h1 { text-align:center; color:#fff; margin-bottom:1.2em; }
    form { display:flex; gap:10px; margin-bottom:1.5em; align-items:center; justify-content:center; flex-wrap:wrap; }
    form input[type="text"], form select { padding:8px 12px; border-radius:5px; border:1px solid #bbb; font-size:1em; background:#fafbfc; transition:border-color 0.2s; width:210px; box-sizing:border-box; }
    form input[type="text"]:focus, form select:focus { border-color:#0078d7; outline:none; background:#fff; }
    form button { padding:8px 18px; border-radius:5px; border:none; background:#0078d7; color:#fff; font-size:1em; cursor:pointer; transition:background 0.2s; }
    form button:hover { background:#005fa3; }
    form a { margin-left:10px; color:#0078d7; text-decoration:underline; font-size:0.98em; }
    ul { list-style:none; padding:0; margin:0 0 1.5em 0; }
    ul li { background:#f3f6fa; margin-bottom:8px; border-radius:5px; padding:10px 14px; display:flex; justify-content:space-between; align-items:center; box-shadow:0 1px 4px #e0e6ed; }
    ul li a { color:#0078d7; text-decoration:underline; font-size:0.97em; margin-left:10px; }
    .volver-link { display:block; text-align:center; margin-top:1.5em; color:#0078d7; text-decoration:underline; font-size:1.05em; }
    </style>
</head>
<body>
    <nav>
    <a href="index.php">Equipos</a>
    <a href="crear_equipo.php">Añadir equipo</a>
    <a href="ubicaciones.php">Ubicaciones</a>
    <a href="estados.php">Estados</a>
    </nav>
    <div class="zonas-container">
        <h1>Zonas</h1>
        <form method="post">
            <input type="hidden" name="id" value="<?= $edit['id'] ?? '' ?>">
            <input type="text" name="nombre" placeholder="Nombre de la zona" value="<?= htmlspecialchars($edit['nombre'] ?? '') ?>" required>
            <select name="ubicacion_id" required>
                <option value="">Selecciona ubicación</option>
                <?php foreach ($ubicaciones as $u): ?>
                    <option value="<?= $u['id'] ?>" <?= (isset($edit['ubicacion_id']) && $edit['ubicacion_id'] == $u['id']) ? 'selected' : '' ?>><?= htmlspecialchars($u['nombre']) ?></option>
                <?php endforeach; ?>
            </select>
            <button type="submit">Guardar</button>
            <?php if ($edit): ?><a href="zonas.php">Cancelar</a><?php endif; ?>
        </form>
        <ul>
            <?php foreach ($zonas as $z): ?>
                <li><?= htmlspecialchars($z['nombre']) ?> (<?= htmlspecialchars($z['ubicacion']) ?>)
                    <span>
                        <a href="?edit=<?= $z['id'] ?>">Editar</a>
                    </span>
                </li>
            <?php endforeach; ?>
        </ul>
        <a class="volver-link" href="index.php">Volver</a>
    </div>
</body>
</html>
