<?php
// public/ubicaciones.php
require_once __DIR__ . '/../src/db.php';
$pdo = getPDO();

// Crear o editar ubicación
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'] ?? '';
    $id = $_POST['id'] ?? '';
    if ($nombre) {
        if ($id) {
            $stmt = $pdo->prepare('UPDATE ubicaciones SET nombre = ? WHERE id = ?');
            $stmt->execute([$nombre, $id]);
        } else {
            $stmt = $pdo->prepare('INSERT INTO ubicaciones (nombre) VALUES (?)');
            $stmt->execute([$nombre]);
        }
    }
    header('Location: ubicaciones.php');
    exit;
}

// Obtener ubicaciones
$ubicaciones = $pdo->query('SELECT * FROM ubicaciones')->fetchAll(PDO::FETCH_ASSOC);
$edit = null;
if (isset($_GET['edit'])) {
    $stmt = $pdo->prepare('SELECT * FROM ubicaciones WHERE id = ?');
    $stmt->execute([$_GET['edit']]);
    $edit = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ubicaciones</title>
    <link rel="stylesheet" href="style.css">
    <style>
    body { background: #f7fafd; font-family: 'Segoe UI', Arial, sans-serif; }
    nav { width:100%;background:#0078d7;padding:0.7em 0 0.7em 0.5em;margin-bottom:1.5em;box-shadow:0 2px 8px #eee;display:flex;gap:1.5em;align-items:center; }
    nav a { color:#fff;font-weight:500;text-decoration:none;font-size:1.1em; }
    .ubicaciones-container { max-width: 480px; margin: 2em auto; background: #fff; border-radius: 10px; box-shadow: 0 2px 12px #e0e6ed; padding: 2em 2em 1.5em 2em; }
    h1 { text-align:center; color:#fff; margin-bottom:1.2em; }
    form { display:flex; gap:10px; margin-bottom:1.5em; align-items:center; justify-content:center; }
    form input[type="text"] { padding:8px 12px; border-radius:5px; border:1px solid #bbb; font-size:1em; background:#fafbfc; transition:border-color 0.2s; width:220px; box-sizing:border-box; }
    form input[type="text"]:focus { border-color:#0078d7; outline:none; background:#fff; }
    form button { padding:8px 18px; border-radius:5px; border:none; background:#0078d7; color:#fff; font-size:1em; cursor:pointer; transition:background 0.2s; }
    form button:hover { background:#005fa3; }
    form a { margin-left:10px; color:#0078d7; text-decoration:underline; font-size:0.98em; }
    ul { list-style:none; padding:0; margin:0 0 1.5em 0; }
    ul li { background:#f3f6fa; margin-bottom:8px; border-radius:5px; padding:10px 14px; display:flex; justify-content:space-between; align-items:center; box-shadow:0 1px 4px #e0e6ed; }
    ul li a { color:#0078d7; text-decoration:underline; font-size:0.97em; margin-left:10px; }
    .volver-link { display:block; text-align:center; margin-top:1.5em; color:#0078d7; text-decoration:underline; font-size:1.05em; }
    </style>
</head>
<body>
    <nav>
    <a href="index.php">Equipos</a>
    <a href="crear_equipo.php">Añadir equipo</a>
    <a href="zonas.php">Zonas</a>
    <a href="estados.php">Estados</a>
    </nav>
    <div class="ubicaciones-container">
        <h1>Ubicaciones</h1>
        <form method="post">
            <input type="hidden" name="id" value="<?= $edit['id'] ?? '' ?>">
            <input type="text" name="nombre" placeholder="Nombre de la ubicación" value="<?= htmlspecialchars($edit['nombre'] ?? '') ?>" required>
            <button type="submit">Guardar</button>
            <?php if ($edit): ?><a href="ubicaciones.php">Cancelar</a><?php endif; ?>
        </form>
        <ul>
            <?php foreach ($ubicaciones as $u): ?>
                <li><?= htmlspecialchars($u['nombre']) ?>
                    <span>
                        <a href="?edit=<?= $u['id'] ?>">Editar</a>
                    </span>
                </li>
            <?php endforeach; ?>
        </ul>
        <a class="volver-link" href="index.php">Volver</a>
    </div>
</body>
</html>
